/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.client.HSCCltObjCache;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.indication.client.HSCCltEventQueue;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCEventHandler;
import com.ibm.hsc.indication.client.HSCIndicationErrLogger;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.rep.client.RClientObject;
import com.ibm.hsc.websm.cec.CECMObject;
import com.ibm.hsc.websm.cec.CECMObjectAssistant;
import com.ibm.hsc.websm.common.CecUtils;
import com.ibm.hsc.websm.common.FrameAttributes;
import com.ibm.hsc.websm.common.LparAttributes;
import com.ibm.hsc.websm.common.ProfileAttributes;
import com.ibm.hsc.websm.common.SysProfileAttributes;
import com.ibm.hsc.websm.common.WSMCommonUtil;
import com.ibm.hsc.websm.frame.FrameMObject;
import com.ibm.hsc.websm.lpar.LPARMObject;
import com.ibm.hsc.websm.profile.ProfileMObject;
import com.ibm.hsc.websm.sysprofile.SysProfileMObject;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.DefSysEventSupport;
import com.ibm.websm.mobject.MOClassImpl;
import com.ibm.websm.mobject.MOState;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class HscCimomListener
extends Thread
implements HSCEventHandler,
HSCIndicationErrLogger {
    private static final String DEBUG_STRING = "@@@@@@@@@@@@@@@@@@@@@@@@@@";
    private static final String CLASS_NAME = "HscCimomListener";
    private static final String METHOD_START = " -> HscCimomListener";
    private static final String METHOD_END = " <- HscCimomListener";
    public static final boolean DEBUG_ON = true;
    private static final int FIVE_SECOND_DELAY = 5000;
    private String _hostName = null;
    public HSCSubscriptionMgr mSubMgr = null;
    public HSCCltEventQueue mQueue = null;
    public static boolean debug = false;

    public void setSubscriptionMgr(HSCSubscriptionMgr hSCSubscriptionMgr) {
        this.mSubMgr = hSCSubscriptionMgr;
    }

    public void setEventQueue(HSCCltEventQueue hSCCltEventQueue) {
        this.mQueue = hSCCltEventQueue;
    }

    public void logException(Throwable throwable) {
        HSCLogUtils.clientLog(throwable, HSCLogUtils._IndicationClassLogInfo);
    }

    public void run() {
        while (null == this._hostName) {
            try {
                this._hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                try {
                    HscCimomListener.sleep(5000L);
                }
                catch (Exception exception2) {}
            }
        }
        int n = 0;
        while (true) {
            int n2;
            try {
                HSCEvent hSCEvent = this.mQueue.getEvent();
                n = HscPerformance.startTransaction("HscCimomListener.asyncEvent");
                this.eventOccured(hSCEvent, this.mSubMgr, 0);
                n2 = 0;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.logException(throwable);
                n2 = 1;
            }
            HscPerformance.endTransaction(n, n2);
        }
    }

    public void clearEventQueue() {
        this.mQueue.clear();
    }

    public void reload() {
        block4: {
            if (IDebug.enabled) {
                System.err.println("HscCimomListener: reload");
            }
            try {
                MOClassImpl mOClassImpl = FrameMObject.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject");
                DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
                if (defSysEventSupport != null) {
                    defSysEventSupport.fireObjReloadMOEvent();
                }
            }
            catch (Throwable throwable) {
                if (!IDebug.enabled) break block4;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void eventOccured(HSCEvent hSCEvent, HSCSubscriptionMgr hSCSubscriptionMgr, int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " -> HscCimomListener.eventOccured");
        }
        String string = hSCEvent.getObjectType();
        int n2 = hSCEvent.getEventType();
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp() + "\n" + METHOD_START + ".eventOccured: " + "eventType: " + n2 + "  objectType: " + string);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("awehhscF", "eventType = " + n2 + "  objectType: " + string);
        }
        HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
        }
        RClientObject rClientObject = (RClientObject)hSCEvent.getNewRObject();
        String string2 = null;
        try {
            string2 = rClientObject.getKey(string);
        }
        catch (Exception exception) {
            return;
        }
        try {
            try {
                switch (n2) {
                    case -1: {
                        if (IDebug.enabled) {
                            System.err.println("lost server connection");
                        }
                        hSCCltObjCache.cleanup();
                        Object var11_11 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    case -2: {
                        this.reload();
                        Object var11_12 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        this._displayMsg(rClientObject, string2, string);
                        Object var11_13 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    case 64: {
                        Object var11_14 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    case 128: {
                        this._CoDCodeComplete(rClientObject, string2, string);
                        Object var11_15 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    case 1: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 304: {
                        if (!string.equals("IBMHSC_Partition") && !string.equals("IBMHSC_LparProfile") && !string.equals("IBMHSC_SystemProfile") || hSCCltObjCache.isParentCreated(rClientObject)) break;
                        if (IDebug.enabled) {
                            System.err.println("ignore event");
                        }
                        Object var11_16 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                    default: {
                        if (IDebug.enabled) {
                            System.err.println("Unknown event: " + n2);
                        }
                        Object var11_17 = null;
                        if (IDebug.enabled) {
                            hSCCltObjCache = HSCCltObjCache.getInstance();
                            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                        }
                        if (1 <= Trace.LEVEL) {
                            Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                        }
                        if (!IDebug.enabled) return;
                        System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                        return;
                    }
                }
                switch (n2) {
                    case 1: 
                    case 16: {
                        this.createEvent(string, string2, rClientObject);
                        break;
                    }
                    case 4: {
                        this.modifyEvent(string, string2, rClientObject, (RClientObject)hSCEvent.getOldRObject());
                        break;
                    }
                    case 2: {
                        this.deleteEvent(string, string2, rClientObject);
                        break;
                    }
                    case 8: {
                        System.err.println("received EVENT_LED_VALUE_CHANGE");
                        this.ledEvent(string, string2, rClientObject);
                        break;
                    }
                    case 304: {
                        this._sysAttnChange(string2, string);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.println(throwable.getMessage());
                throwable.printStackTrace();
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                Object var11_19 = null;
                if (IDebug.enabled) {
                    hSCCltObjCache = HSCCltObjCache.getInstance();
                    System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
                }
                if (!IDebug.enabled) return;
                System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
                return;
            }
            {
            }
            Object var11_18 = null;
            if (IDebug.enabled) {
                hSCCltObjCache = HSCCltObjCache.getInstance();
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
            }
            if (!IDebug.enabled) return;
            System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
            return;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (IDebug.enabled) {
                hSCCltObjCache = HSCCltObjCache.getInstance();
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@ obj Cache\n" + hSCCltObjCache.toString() + DEBUG_STRING);
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace("awehhscT", " <- HscCimomListener.eventOccured");
            }
            if (!IDebug.enabled) throw throwable;
            System.err.println(" <- HscCimomListener.eventOccured\n@@@@@@@@@@@@@@@@@@@@@@@@@@: " + WSMCommonUtil.timeStamp());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sysAttnChange(String string, String string2) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@\n_sysAttnChange()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", "-> _sysAttnChange()");
        }
        try {
            Hashtable<String, MOState> hashtable = new Hashtable<String, MOState>();
            boolean bl = false;
            String string3 = "";
            MOState mOState = null;
            if ("IBMHSC_ComputerSystem".equals(string2)) {
                MOXReference mOXReference = this.getMOXRefFromType(string, string2);
                bl = CecUtils.isSALed(mOXReference.getKey(), this._hostName);
                mOState = bl ? new MOState("hsc_managed_sys", null, "so_warning", true) : new MOState("hsc_managed_sys", null, null, true);
                hashtable.put("MOState", mOState);
                MObjectImpl mObjectImpl = this.getMObjectImpl(string, string2);
                ((CECMObject)mObjectImpl).setPropertyValues(hashtable, null, null);
            } else if ("IBMHSC_Partition".equals(string2)) {
                // empty if block
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
        finally {
            if (1 <= Trace.LEVEL) {
                Trace.trace("awehhscT", " <- __sysAttnChange ");
            }
        }
    }

    private void _CoDCodeComplete(RClientObject rClientObject, String string, String string2) {
        block9: {
            try {
                Object object = rClientObject.getProperty("CodCodeCompleteStatus");
                if (null == object) break block9;
                short s = ((UnsignedInt8)object).shortValue();
                String string3 = 1 != s ? HSCResourceBundleUtil.getMessage("CoDMsgBundle", "050F", "The CoD code has been rejected by the managed system because it is not valid.  Contact your CoD administrator.") : HSCResourceBundleUtil.getMessage("CoDMsgBundle", "050C", "The CoD code has been accepted.");
                try {
                    MObjectImpl mObjectImpl;
                    if (IDebug.enabled) {
                        System.err.println("statusMsg = " + string3);
                    }
                    if ((mObjectImpl = this.getMObjectImpl(string, string2)) != null) {
                        CECMObject.displayActivationMsg(this._hostName, string3, mObjectImpl.getName(), mObjectImpl);
                    } else if (IDebug.enabled) {
                        System.err.println("Object impl is null");
                    }
                }
                catch (Throwable throwable) {
                    if (IDebug.enabled) {
                        throwable.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
    }

    private void _displayMsg(RClientObject rClientObject, String string, String string2) {
        try {
            Object object = rClientObject.getProperty("CodAsyncMsgList");
            if (null != object) {
                MObjectImpl mObjectImpl = this.getMObjectImpl(string, string2);
                CECMObject.displayCoDMsg(this._hostName, (Vector)object, mObjectImpl.getName());
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
    }

    private void createEvent(String string, String string2, RClientObject rClientObject) {
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " -> HscCimomListener.createEvent");
        }
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@\ncreateEvent: type: " + string);
        }
        boolean bl = false;
        if (string.equals("IBMHSC_Frame")) {
            this.createFrameMObject(rClientObject);
        } else if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
            bl = this.createCECMObject(rClientObject, string2);
        } else if (string.equals("IBMHSC_Partition")) {
            bl = this.createLPARMObject(rClientObject, string2);
        } else if (string.equals("IBMHSC_LparProfile")) {
            this.createLPARProfileMObject(rClientObject, string2);
        } else if (string.equals("IBMHSC_SystemProfile")) {
            this.createSysProfileMObject(rClientObject, string2);
        }
        if (bl) {
            HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
            hSCCltObjCache.addObject(rClientObject);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " <- HscCimomListener.createEvent");
        }
    }

    private void createFrameMObject(RClientObject rClientObject) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createFrameMObject");
        }
        try {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.frame.FrameMObject");
            if (null == mOClassImpl) {
                if (IDebug.enabled) {
                    System.err.println("createFrameMObject: MObjectImpl.getMOClassImpl returned null");
                }
                throw new Exception();
            }
            Hashtable hashtable = FrameAttributes.mapRObjectToMObject(rClientObject);
            mOClassImpl.createNewMObject(hashtable, null);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createFrameMObject: SUCCESS");
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logException(throwable);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createFrameMObject: FAILED");
            }
            return;
        }
    }

    private boolean createCECMObject(RClientObject rClientObject, String string) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createCECMObject");
        }
        try {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.cec.CECMObject");
            if (null == mOClassImpl) {
                if (IDebug.enabled) {
                    System.err.println("createCECMObject: MObjectImpl.getMOClassImpl returned null");
                }
                throw new Exception();
            }
            Hashtable hashtable = CECMObjectAssistant.mapRObjectToMObject(rClientObject, string);
            mOClassImpl.createNewMObject(hashtable, null);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createCECMObject: SUCCESS");
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logException(throwable);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createCECMObject: FAILED");
            }
            return false;
        }
    }

    private boolean createLPARMObject(RClientObject rClientObject, String string) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createLPARMObject");
        }
        try {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.lpar.LPARMObject");
            if (null == mOClassImpl) {
                if (IDebug.enabled) {
                    System.err.println("createLPARMObject: MObjectImpl.getMOClassImpl returned null");
                }
                throw new Exception();
            }
            Hashtable hashtable = LparAttributes.mapRObjectToMObject(rClientObject, string);
            Short s = (Short)hashtable.get("state_PROP");
            s = new Short((short)(s | 0x1000));
            hashtable.put("state_PROP", s);
            mOClassImpl.createNewMObject(hashtable, null);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createLPARMObject: SUCCESS");
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logException(throwable);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createLPARMObject: FAILED");
            }
            return false;
        }
    }

    private void createLPARProfileMObject(RClientObject rClientObject, String string) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createProfileMObject");
        }
        try {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
            if (null == mOClassImpl) {
                if (IDebug.enabled) {
                    System.err.println("createLPARProfileMObject: MObjectImpl.getMOClassImpl returned null");
                }
                throw new Exception();
            }
            Hashtable hashtable = ProfileAttributes.mapRObjectToMObject(rClientObject, string, this._hostName);
            mOClassImpl.createNewMObject(hashtable, null);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createLPARProfileMObject: SUCCESS");
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logException(throwable);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createLPARMObject: FAILED");
            }
            return;
        }
    }

    private void createSysProfileMObject(RClientObject rClientObject, String string) {
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createSysProfileMObject");
        }
        try {
            MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.sysprofile.SysProfileMObject");
            if (null == mOClassImpl) {
                if (IDebug.enabled) {
                    System.err.println("createSysProfileMObject: MObjectImpl.getMOClassImpl returned null");
                }
                throw new Exception();
            }
            Hashtable hashtable = rClientObject.getAllProperties();
            Hashtable hashtable2 = SysProfileAttributes.mapRObjectToMObject(hashtable, string);
            mOClassImpl.createNewMObject(hashtable2, null);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createSysProfileMObject: SUCCESS");
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.logException(throwable);
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@  createSysProfileMObject: FAILED");
            }
            return;
        }
    }

    private void deleteEvent(String string, String string2, RClientObject rClientObject) {
        block15: {
            if (1 <= Trace.LEVEL) {
                Trace.trace("awehhscT", " -> HscCimomListener.deleteEvent");
            }
            if (IDebug.enabled) {
                System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@\ndeleteEvent: type: " + string);
            }
            boolean bl = false;
            Vector<MOXReference> vector = new Vector<MOXReference>();
            try {
                MOXReference mOXReference = this.getMOXRefFromType(string2, string);
                if (string.equals("IBMHSC_Frame")) {
                    FrameMObject.deleteFrameMObject(mOXReference);
                } else if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
                    CECMObject.deleteCECMObject(mOXReference);
                    bl = true;
                } else if (string.equals("IBMHSC_Partition")) {
                    vector.add(mOXReference);
                    LPARMObject.DeleteLPARMObject(vector);
                    bl = true;
                } else if (string.equals("IBMHSC_LparProfile")) {
                    vector.add(mOXReference);
                    ProfileMObject.DeleteProfileMObject(vector);
                } else if (string.equals("IBMHSC_SystemProfile")) {
                    vector.add(mOXReference);
                    SysProfileMObject.DeleteSysProfileMObject(vector);
                }
                if (bl) {
                    HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
                    hSCCltObjCache.remove(rClientObject);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.logException(throwable);
                if (!IDebug.enabled) break block15;
                System.err.println("EXCEPTION: method: HscCimomListener.deleteEvent");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " <- HscCimomListener.deleteEvent");
        }
    }

    private void modifyEvent(String string, String string2, RClientObject rClientObject, RClientObject rClientObject2) {
        String string3;
        Object object;
        MObjectImpl mObjectImpl;
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " -> HscCimomListener.modifyEvent");
        }
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@\n -> modifyEvent: type: " + string);
        }
        try {
            mObjectImpl = this.getMObjectImpl(string2, string);
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        Hashtable hashtable = rClientObject.getChangedProperties(rClientObject2, true);
        if (IDebug.enabled) {
            object = hashtable.keys();
            System.err.println("update properties @@@@@@@@@@@@@@@@@@@@@@@@@@");
            while (object.hasMoreElements()) {
                string3 = (String)object.nextElement();
                System.err.println("key: " + string3 + "  value: " + hashtable.get(string3));
            }
            System.err.println(DEBUG_STRING);
        }
        if (string.equals("IBMHSC_Frame")) {
            try {
                Hashtable hashtable2 = FrameAttributes.getAttributes(hashtable, null);
                ((FrameMObject)mObjectImpl).setPropertyValues(hashtable2, null, null);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: modify Frame FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        } else if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
            try {
                Hashtable hashtable3 = CECMObjectAssistant.getAttributes(hashtable, (UnsignedInt8)rClientObject.getProperty("State"), CECMObjectAssistant.CACHED_KEYS);
                ((CECMObject)mObjectImpl).setPropertyValues(hashtable3, null, null);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: modify CEC FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        } else if (string.equals("IBMHSC_Partition")) {
            try {
                Hashtable hashtable4 = LparAttributes.getAttributes(hashtable, string2, null);
                object = (UnsignedInt8)rClientObject.getProperty("PartitionState");
                hashtable4.put("state_PROP", new Short(object.shortValue()));
                ((LPARMObject)mObjectImpl).setPropertyValues(hashtable4, null, null);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: modify lpar FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        } else if (string.equals("IBMHSC_LparProfile")) {
            try {
                Hashtable hashtable5;
                if (0 == hashtable.size()) {
                    hashtable5 = new Hashtable();
                    object = (String)rClientObject.getProperty("SettingID");
                    string3 = (String)rClientObject.getProperty("PartitionName");
                    hashtable5.put("isDefaultProfile_PROP", ProfileAttributes.isDefaultProfile(this._hostName, (String)object, string3));
                    if (IDebug.enabled) {
                        System.err.println("LparProfile: isDefaultProfile_PROP: " + hashtable5.get("isDefaultProfile_PROP"));
                    }
                } else {
                    hashtable5 = ProfileAttributes.getAttributes(hashtable, null);
                }
                if (hashtable5.size() > 0) {
                    ((ProfileMObject)mObjectImpl).setPropertyValues(hashtable5, null, null);
                }
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: modify profile FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        } else if (string.equals("IBMHSC_SystemProfile")) {
            try {
                Hashtable hashtable6 = ProfileAttributes.getAttributes(hashtable, null);
                if (hashtable6.size() > 0) {
                    ((SysProfileMObject)mObjectImpl).setPropertyValues(hashtable6, null, null);
                }
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: system modify profile FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " -> HscCimomListener.modifyEvent");
        }
        if (IDebug.enabled) {
            System.err.println(" <- modifyEvent\n@@@@@@@@@@@@@@@@@@@@@@@@@@");
        }
    }

    private void ledEvent(String string, String string2, RClientObject rClientObject) {
        MObjectImpl mObjectImpl;
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " -> HscCimomListener.ledEvent");
        }
        if (IDebug.enabled) {
            System.err.println("@@@@@@@@@@@@@@@@@@@@@@@@@@\n -> ledEvent: type: " + string);
        }
        try {
            mObjectImpl = this.getMObjectImpl(string2, string);
        }
        catch (Exception exception) {
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
            try {
                Hashtable hashtable = new Hashtable();
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("OpPanelValue", rClientObject.getProperty("OpPanelValue"));
                hashtable = CECMObjectAssistant.getAttributes(hashtable2, (UnsignedInt8)rClientObject.getProperty("State"), CECMObjectAssistant.CACHED_KEYS);
                ((CECMObject)mObjectImpl).setPropertyValues(hashtable, null, null);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    System.err.println("EXCEPTION: modify CEC FAILED");
                }
                throwable.printStackTrace();
                this.logException(throwable);
            }
        } else {
            System.err.println("invalid object type for LED update");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace("awehhscT", " <- HscCimomListener.ledEvent");
        }
        if (IDebug.enabled) {
            System.err.println(" <- ledEvent\n@@@@@@@@@@@@@@@@@@@@@@@@@@");
        }
    }

    private String getMOClass(String string) throws Exception {
        String string2;
        if (string.equals("IBMHSC_Frame")) {
            string2 = "com.ibm.hsc.websm.frame.FrameMObject";
        } else if (string.equals("IBMHSC_ComputerSystem") || string.equals("IBMHSC_FrameCompSys")) {
            string2 = "com.ibm.hsc.websm.cec.CECMObject";
        } else if (string.equals("IBMHSC_Partition")) {
            string2 = "com.ibm.hsc.websm.lpar.LPARMObject";
        } else if (string.equals("IBMHSC_LparProfile")) {
            string2 = "com.ibm.hsc.websm.profile.ProfileMObject";
        } else if (string.equals("IBMHSC_SystemProfile")) {
            string2 = "com.ibm.hsc.websm.sysprofile.SysProfileMObject";
        } else {
            throw new Exception("getMOClass: invalid object type: " + string);
        }
        if (IDebug.enabled) {
            System.err.println("MOClass: " + string2);
        }
        return string2;
    }

    private MOClassImpl getMOClassImplFromMOClass(String string) throws Throwable {
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)string);
        if (IDebug.enabled) {
            System.err.println("classImpl: " + mOClassImpl);
        }
        if (null == mOClassImpl) {
            if (IDebug.enabled) {
                System.err.println("getMOClassImpl: MObjectImpl.getMOClassImpl returned null");
            }
            throw new Exception("MObjectImpl.getMOClassImpl returned null");
        }
        return mOClassImpl;
    }

    private MOClassImpl getMOClassImplFromType(String string) throws Throwable {
        String string2 = this.getMOClass(string);
        return this.getMOClassImplFromMOClass(string2);
    }

    private MOXReference getMOXRefFromType(String string, String string2) throws Throwable {
        String string3 = this.getMOClass(string2);
        return this.getMOXRefFromMOClass(string, string3);
    }

    private MOXReference getMOXRefFromMOClass(String string, String string2) throws Throwable {
        try {
            MOXReference mOXReference = MOClassImpl.getMOXReference((String)string2, (String)string);
            if (IDebug.enabled) {
                System.err.println("moxref: " + mOXReference);
            }
            return mOXReference;
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                System.err.println("getMOXReference failed\n" + throwable.getMessage());
            }
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            throw throwable;
        }
    }

    private MObjectImpl getMObjectImpl(String string, String string2) throws Throwable {
        String string3 = this.getMOClass(string2);
        MOXReference mOXReference = this.getMOXRefFromMOClass(string, string3);
        MOClassImpl mOClassImpl = this.getMOClassImplFromMOClass(string3);
        try {
            MObjectImpl mObjectImpl = mOClassImpl.getMObjectImpl(mOXReference);
            if (2 <= Trace.LEVEL) {
                Trace.trace("awehhscF", "moxRef: " + mOXReference + "\nmObjectImpl: " + mObjectImpl);
            }
            if (IDebug.enabled) {
                System.err.println("getMObjectImpl: retrieved MObject instance");
            }
            return mObjectImpl;
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                System.err.println("MOClassImpl failed\n" + throwable.getMessage());
            }
            HSCLogUtils.clientLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            throw throwable;
        }
    }
}

